
from setuptools import setup, find_packages

##
## Prevent setuptools from trying to add extra files to the source code
## manifest by scanning the version control system for its contents.
##
from setuptools.command import sdist
del sdist.finders[:]

setup(
   name = "miopia",
    version = "1.0.0",
    author = "David Vilares Calvo",
    author_email = "david.vilares@udc.es",
    description =  'Sentiment Analysis and Opinion Mining',
    long_description = 'Supervised and Unsupervised Sentiment Analysis based on Natural Language Processing',
    url = 'www.fic.udc.es',
    packages = ['miopia',
        'miopia.adapter',
        'miopia.analyzer',
        'miopia.analyzer.counter',
        'miopia.classifier',
        'miopia.parser',
        'miopia.preparator',
        'miopia.preprocessor',
        'miopia.tagger',
        'miopia.util.exceptions',
        'demo',
        'api'],
    py_modules = ['miopia.util.ConfigurationManager',
                  'miopia.util.BinaryTree',
                  'miopia.util.TextInfo',
                  'miopia.util.TokenInfo'],
    include_package_data=True,
    data_files = [('/etc', ['miopia/miopia-1.0.0_conf.yaml'])],
    zip_safe=False,
 classifiers = [ 'Programming Language :: Python :: 2.7']
)
