'''
@author: david.vilares
'''
import os
import yaml
import re
import codecs
from collections import defaultdict

class ConfigurationManager(object):
    '''
    classdocs
    '''
    __config = {}
    __parameters = {}  
    __default_conf_file = "/etc/miopia-1.0.0_conf.yaml"#os.path.dirname(os.path.abspath(__file__))+os.sep+os.path.pardir+os.sep+'miopia_conf.yaml'
    #__default_conf_file = os.path.dirname(os.path.abspath(__file__))+os.sep+os.path.pardir+os.sep+'miopia_conf.yaml'
    __uniqueInstance = None
    __lang = 'es'
        
    def __new__(self, *args, **kargs): 
        """
        Singleton
        """
        if self.__uniqueInstance is None:
            self.__uniqueInstance = object.__new__(self, *args, **kargs)
        return self.__uniqueInstance

    def __init__(self, 
                 config_file = None,  
                 yaml_config=None, lang = 'es'):
        '''
        Constructor
        '''
        self.__lang = lang
        if yaml_config != None:
            self.__config = yaml_config
        else:
            if config_file != None:
                self.__config = yaml.load(open(config_file,'r'))
            else:
                self.__config = yaml.load(open(self.__default_conf_file,'r'))
        
    def getParameter(self,parameter, lang=None):
        if lang==None: 
            lang=self.__lang
        
        if 'config_'+lang in self.__config and parameter in self.__config['config_'+lang]:
            value =  self.__config['config_'+lang][parameter]
        else:
            if parameter in self.__config['default']:
                value = self.__config['default'][parameter]
            else:
                value = None
            
        #substiutute relative paths with absolute paths
        if re.match('^path_',parameter):
            rootpath = self.getParameter("ROOTPATH", lang)
            if rootpath != None and value!= None:
                value = re.sub(r'^ROOTPATH', rootpath, value)
                
        return value
    
    #def readLemmaD
    def readLemmaDict(self, path, encoding="utf-8"):
        words = codecs.open(path,encoding=encoding).readlines()
            
        D = defaultdict(defaultdict)
        for word in words:
            columns = word.split('\t')
            if len(columns) == 3:
                D[columns[0]][columns[1]] = columns[2][0:len(columns[2])-1]
        return D
    
    def readSODict(self,path,encoding="utf-8"):
        d = self.readTsvDict(path, encoding)
        for k in d:
            d[k] = float(d[k])
        return d
    
    def readTsvDict(self, path, encoding="utf-8"):
        dictionary = {}
        try:
            lines = codecs.open(path,encoding=encoding).readlines()
            for line in lines:
                cols = line.split('\t')
                cols = [ c.replace('\n'.encode(),''.encode()) for c in cols if c not in ['\n','']]
                if len(cols)>0 and cols[0]!='\n':
                    if len(cols) == 1:
                        dictionary[cols[0]] = ''
                    elif len(cols) == 2:
                        dictionary[cols[0]] = cols[1]
                    else:
                        dictionary[cols[0]] = cols[1:]
        except Exception as e:
            print path, len(dictionary)
            print "EXCEPTION:",e
            return dictionary
        return dictionary
