'''
Created on 14/06/2013

@author: david.vilares
'''


class Node:
    
    def __init__(self, key, data):
        # initializes the data members
        self.left = None
        self.right = None
        self.data = data
        self.key = key

class BinaryTree:
    def __init__(self):
        # initializes the root member
        self.root = None
    
    def addNode(self, key,data):
        # creates a new node and returns it
        return Node(key,data)

    def insert(self, root, key, data):
        # inserts a new data
        if root == None:
            # it there isn't any data
            # adds it and returns
            self.root = self.addNode(key,data)
            return self.addNode(key,data)
        else:
            # enters into the tree
            if key <= root.key:
                # if the data is less than the stored one
                # goes into the left-sub-tree
                root.left = self.insert(root.left, key,data)
            else:
                # processes the right-sub-tree
                root.right = self.insert(root.right, key,data)
            return root
        
    def printTree(self, root):
        # prints the tree path
        if root == None:
            pass
        else:
            self.printTree(root.left)
            print root.key,
            self.printTree(root.right)
            
            
    def lookup(self, root, target):
        # looks for a value into the tree
        if root == None:
            return 0
        else:
            # if it has found it...
            if target == root.key:
                return 1
            else:
                if target < root.key:
                    # left side
                    return self.lookup(root.left, target)
                else:
                    # right side
                    return self.lookup(root.right, target)


    def search_longest_match(self,root,target):
        if root == None:
            return None
        if target.startswith(root.key): 
            if target < root.key:
                #print "Entra", target, root.key, root.data
                return self.search_longest_match(root.right, target)
            else:
                return root.data
        else:
            if target < root.key:
                return self.search_longest_match(root.left,target)
            else:
                return self.search_longest_match(root.right, target)
            
        
## create the binary tree
#BTree = BinaryTree()
#    # add the root node
#root = BTree.addNode('administrador',[1,2])
#    # ask the user to insert values
#
#
#n1 = Node('aa',[3,4])
#n2 = Node('pa',[4,5])
#
#for i in [n1,n2]:  # insert values
#    print BTree.insert(root, i.key,i.data)
#    
#BTree.printTree(root)
