from textblob_aptagger import PerceptronTagger
from miopia.tagger.InfoTag import InfoTag

class PerceptronTwitTagger(PerceptronTagger):
    def tag(self, words):
        prev, prev2 = self.START
        tokens = []
    
        context = self.START + [self._normalize(w) for w in words] + self.END
        for i, word in enumerate(words):
            tag = self.tagdict.get(word)
            if not tag:
                features = self._get_features(i, word, context, prev, prev2)
                tag = self.model.predict(features)
            tokens.append((word, tag))
            prev2 = prev
            prev = tag
        
        tokens_info = []
        for tag in tokens:
            tokens_info.append((tag[0],InfoTag(tag[1],tag[1],'_')))
        return tokens_info