#-*- coding: utf-8 -*-

'''
@author: David Vilares Calvo
'''
import re
from miopia.preprocessor.PreProcessorDecorator import PreProcessorDecorator


class TwitterUserNameProcessor(PreProcessorDecorator):
    '''
    classdocs
    '''

    '''
    Constructor
    @param component: An instance defined by the interface L{PreProcessorI}
    '''
    def __init__(self,component):
        self._component = component
        self._rt_and_user_pattern = re.compile('RT[ ]*@{1}[\w:]{1,}')
        self._user_pattern = re.compile('@\w')
        


    def preprocess(self,text):
        """
        Preprocess twitter usernames
        @param text: A tweet. It is a String
        """    

        ptext = self._twitter_names_transformation(text)
        return self._component.preprocess(ptext)

        
    def _twitter_names_transformation(self,text):
        """
        @param text. A tweet. It is a String
        """     

        #Deleting RT @username ocurrences
        #rt_user_names = re.findall('RT[ ]*@{1}[\w:]{1,}',text) 
        rt_user_names = self._rt_and_user_pattern.findall(text)  
        for rt_user_name in rt_user_names:
            text = text.replace(rt_user_name,'')
        
        #TODO: Delete consecutively user names   
        
        #Changing @username ocurrences by only Username
        #user_names = re.findall('@\w',text)
        user_names = self._user_pattern.findall(text)
        for name in user_names:
            text = text.replace(name[0:],name[1].upper())
        return text