'''
Created on 06/02/2013

@author: David Vilares Calvo
'''

from miopia.preprocessor.PreProcessorDecorator import PreProcessorDecorator
from miopia.util.exceptions.LanguageNotSupportedException import LanguageNotSupportedException
import re

class InterjectionPreProcessor(PreProcessorDecorator):
    '''
    classdocs
    '''

    laugh_consonant='j'

    def __init__(self,component, lang='es'):
        '''
        Constructor
        '''
        self._component = component
        if lang == 'en':
            self.laugh_consonant = 'h'
        elif lang == 'es':
            self.laugh_consonant = 'j'
        else:
            raise LanguageNotSupportedException(lang)
        
    def preprocess(self,text):
        """
        @param text: A String.
        @return A processed string with normalised laughs
        """
        return self._component.preprocess(self._normalize_laughs(text))
        
        
    def _normalize_laughs(self,text):
        
        def normalise_laugh(vocal,text):
            cons = self.laugh_consonant
            
            regex = '['+cons+cons.upper()+vocal+vocal.upper()+']{4,}'      
            laughs =  re.findall(regex,text)
            normalised_cap_laugh = cons.upper()+vocal.upper()+cons.upper()+vocal.upper()
            normalised_lower_laugh = cons+vocal+cons+vocal
            for laugh in laughs:
                #otherwise is not really a laugh
                if laugh.find(cons) != -1 or laugh.find(cons.upper()) != -1:        
                    if laugh.isupper(): 
                        text = text.replace(laugh,normalised_cap_laugh)
                    else: 
                        text = text.replace(laugh,normalised_lower_laugh)  
            return text
        
        for vocal_laugh in ['a','e','i','o','u']:
            text = normalise_laugh(vocal_laugh,text)
                   
        return text
        