#-*- coding: utf-8 -*- 

'''
@author: David Vilares Calvo
'''

import codecs
from miopia.util.ConfigurationManager import ConfigurationManager
from miopia.preprocessor.PreProcessorDecorator import PreProcessorDecorator


class EmoticonPreProcessor(PreProcessorDecorator):
    '''
    classdocs
    '''

    def __init__(self,component, emoticon_dict=None):
        '''
        Constructor
        '''
        self._component = component
        if emoticon_dict is None:
            self._emoticon_dict = self._get_emoticon_dict(ConfigurationManager().getParameter("path_emoticon_dict")) 
        else:
            self._emoticon_dict = emoticon_dict
        
        
    def _get_emoticon_dict(self,name_of_dict,coding="utf-8"):
        """
        @param name_of_dict: The path to a semantic orientiation diccionary
        @return: A dictionary {word,semantic orientation value}
        """
        words = codecs.open(name_of_dict,encoding=coding).readlines()
        D = {}
        for word in words:
            columns = word.split()
            length = len(columns) - 1
            
            for i in range(0, length-1):
                D[columns[i]] = columns[length].replace("\n","")
        return D

    
    def preprocess(self,text):
        """
        Preprocess emoticons and call preprocess component function
        @param text: A String
        """
        if isinstance(text, str):
            text = unicode(text,'utf-8',errors="ignore")
        elif isinstance(text, unicode):
            pass
        ptext = self._emoticon_transformation(text)
        return self._component.preprocess(ptext)
    
    

    
    def _emoticon_transformation(self,text):
        """
        @param text: A String
        @return: A processed text where emoticons has been processed
        """
        list_emoticon = self._emoticon_dict.keys()
        emoticons_found = []
           
#        def build_new_sentence(string):
#            if not string.startswith("."):
#                string = ". "+string
#            if not string.endswith("."):
#                string =string+"."
#            return string
                  
        for emoticon in list_emoticon:
            if (emoticon in text) and emoticon not in emoticons_found:
                emoticons_found.append(emoticon)
                
        emoticons_found.sort(key=len,reverse=True)
        for e in set(emoticons_found):
            text = self._build_new_text(text, e, self._emoticon_dict[e])
           # text = text.replace(e, self._build_new_sentence(self._emoticon_dict[e]))
        return text
        
