'''
@author: David Vilares
'''

from collections import defaultdict


class LexicalValenceShifter(object):
    '''
    It describes the phemonona supported by the class L{LexicalSentimentInfo}
    '''
    REPLICATION = "REPLICATION"
    CAPS = "CAPS"


class LexicalSentimentInfo(object):
    #TODO: Correctly integrate with the remainder of the system
    '''
    This class stores auxiliary information about the no preprocessed text
    that could be useful in next steps
    '''
    def __init__(self):
        '''
        Constructor
        '''
        #dict has set's as values
        self._dict = defaultdict(defaultdict)     
    
    
    def add_lexical_valence_shifter(self,id_sentence,id_token,
                                    type_valence_shifter):   
        try:        
            self._dict[id_sentence][id_token].append(type_valence_shifter)
        except KeyError:
            self._dict[id_sentence][id_token] = [type_valence_shifter]
        

    def get_dict(self):
        return self._dict

    def get_sentence_info(self,id_sentence):
        try:
            return self._dict[id_sentence]
        except:
            return None

        
    def get_element(self,id_sentence,id_token):
        try:
            return self._dict[id_sentence][id_token]
        except:
            return None