'''
@author: David Vilares Calvo
'''

class TokenDependencyInfo(object):
    """
    It Saves information of a token coherently with the CoNLL 2006 format
    """

    def __init__(self,form,finetag,head,deprel):
        """
        Constructor
        @param form: A string. The 'word' of the token.
        @param finetag: A string. The part-of-speech tag of the token.
        @param head: An integer. The identifier of the head of the token.
        @param deprel: An integer. The identifier of the dependent node of the token.
        """
        self._form = form
        self._finetag = finetag
        self._head = head
        self._deprel = deprel
    
    def get_form(self):
        return self._form
    
    def get_finetag(self):
        return self._finetag
    
    def set_finetag(self,finetag):
        self._finetag = finetag
    
    def get_head(self):
        return self._head

    def set_head(self,head):
        self._head = head
        
    def get_deprel(self):
        return self._deprel
    
    def set_deprel(self,deprel):
        self._deprel = deprel