'''
Created on 29/01/2013

@author: David Vilares Calvo
'''

from miopia.classifier.ClassifierI import ClassifierI
from miopia.classifier.PolarityType import PolarityType
from miopia.classifier.WekaClassificationStrategy import WekaClassificationStrategy
from miopia.util.exceptions.InvalidStrategyException import InvalidStrategyException

from miopia.analyzer.SentimentAnalyzer import SentimentAnalyzer
import time
class SimpleClassifier(ClassifierI):
    '''
    A wrapper for the L{CLassifierI}.
    @todo: Only wraps L{WekaClassificationStrategy at the moment}
    '''
    MAX_JOINT_FILES = 30000 #The maximum number of file to classify in one call to WEKA



    def __init__(self, classification_strategy, 
                 list_handlers=[], polarity_type_handled=None):    
        #TODO: Test matching between Analyzer and ClassificationStrategy
        """
        @param classification_stategy: An instance of L{WekaClassificationStrategy}
        @param list_handlers: A list with your L{SimpleClassifier} which are your handlers classifiers. Empty list if no handler classifier
        @param polarity_type_handled: A value of L{PolarityType}. None if there is no handler
        """
                
        self._strategy = classification_strategy      
        self._list_handlers = list_handlers
        self._polarity_type_handled = polarity_type_handled



#    def __init__(self, analyzer, classification_strategy, 
#                 list_handlers, polarity_type_handled):    
#        #TODO: Test matching between Analyzer and ClassificationStrategy
#        """
#        @precondition: L{SentimentAnalyzer} does not handle L{WekaClassificationStrategy} 
#        and L{LinguisticAnalyzer} only manages L{WekaClassificationStrategy} 
#        @param analyzer: An instance of L{Analyzer}
#        @param classification_stategy: An instance of L{ClassificationStrategy}
#        @param list_handlers: A list with your L{SimpleClassifier} which are your handlers classifiers. Empty list if no handler classifier
#        @param polarity_type_handled: A value of L{PolarityType}. None if there is no handler
#        """
#                
#        self._analyzer = analyzer
#        self._classification_strategy = classification_strategy   
#        if self.has_linguistic_analyzer() and not self.has_supervised_strategy():
#            raise InvalidStrategyException
#        if self.has_sentiment_analyzer() and self.has_supervised_strategy():
#            raise InvalidStrategyException
#        
#        self._list_handlers = list_handlers
#        self._polarity_type_handled = polarity_type_handled


#    def get_analyzer(self):
#        return self._analyzer
#      
#    def has_sentiment_analyzer(self):
#        return isinstance(self._analyzer,SentimentAnalyzer)
#    
#    
#    def has_supervised_strategy(self):
#        return isinstance(self._classification_strategy,WekaClassificationStrategy)
      
    def _disambiguate_lists_id_polarities(self,list_id_polarities):
        """
        Merge list_a and list_b prioritizing values of list_b
        @param list_a: list of tuples id, L{PolarityType}
        @param list_b: list of tuples id, L{PolarityType}
        """
        def rules(list_polarities_confidence):
            
            dict_polarities_confidence = {polarity:confidence for polarity,confidence in list_polarities}
            set_polarities = set(dict_polarities_confidence.keys())
            
            if len(set_polarities) == 0:
                return PolarityType.OTHER,0.
            if len(set_polarities) == 1:
                aux = set_polarities.pop()
                return aux,dict_polarities_confidence[aux]
            else:
                a = PolarityType.NONE
#                a = PolarityType.NONE       
#                if PolarityType.NONE in set_polarities : set_polarities.remove(PolarityType.NONE)
                if ((PolarityType.POSITIVE in set_polarities or PolarityType.STRONG_POSITIVE in set_polarities) and 
                    (PolarityType.NEGATIVE in set_polarities or PolarityType.STRONG_NEGATIVE in set_polarities)):
                    
                    total_confidence = 0.
                    number_polarities = 0. 
                    for polarity in set_polarities:
                        set_polarities.pop()
                        number_polarities+=1
                        total_confidence+=1
                    
                    return PolarityType.NEUTRAL, (total_confidence / number_polarities)     
                if (PolarityType.POSITIVE) in set_polarities:
                    return PolarityType.POSITIVE, dict_polarities_confidence[PolarityType.POSITIVE]
                if (PolarityType.STRONG_POSITIVE) in set_polarities:
                    return PolarityType.STRONG_POSITIVE, dict_polarities_confidence[PolarityType.STRONG_POSITIVE]
                if (PolarityType.NEGATIVE) in set_polarities:
                    return PolarityType.NEGATIVE, dict_polarities_confidence[PolarityType.NEGATIVE]
                if (PolarityType.STRONG_NEGATIVE) in set_polarities:
                    return PolarityType.STRONG_NEGATIVE, dict_polarities_confidence[PolarityType.STRONG_NEGATIVE]
            return a
        
        list_id_fixed_polarity = []
        for (id, list_polarities) in list_id_polarities:  
            aux_tuple = rules(list_polarities)
            list_id_fixed_polarity.append((id, aux_tuple[0], aux_tuple[1]))        
        return list_id_fixed_polarity


#    def classify_from_info(self,info,**kwargs):
#        """
#        @param info: Either a L{SentimentInfo} or a L{LinguisticInfo}
#        @param **kwargs: Needed key 'dict_adapted_features' if info is a L{LinguisticInfo} 
#        @return: A L{PolarityType}
#        """
#        return self._classification_strategy.polarity_info(info,**kwargs)
#
#    def classify_from_list_info(self,list_info,**kwargs):
#        """
#        @param list_info: A list of either (id,L{SentimentInfo}) or (id,L{LinguisticInfo}) objects
#        @param **kwargs: Needed key 'dict_adapted_features' if info is a L{LinguisticInfo} 
#        @return: A list of tuples (id,L{PolarityType})
#        """
#        return self._classification_strategy.polarity(list_info,**kwargs)




    def classify(self, arff_file, results_file, dict_position_instanceid):
        #TODO: Classify algo information provided by the SentimentAnalyzer
        """
        @param arff_file: A string. The path to the ARFF file to be classified
        @param results_file: A string. The path where will be printed the WEKA classifications.
        @para dict_position_instanceid: A dictionary {position_in_arff: file_id}, which contains
        relates the position of each instance in the ARFF DATA file which their corresponding textid.
        """
 
        list_id_classifications = self._strategy.classify(arff_file,results_file,
                                                          dict_position_instanceid)

        list_handled_path_files, list_aux_id_polarities = [],[]
        dict_handler_id_polarities = {}
        for (id,polarity,confidence) in list_id_classifications:
            if polarity == self._polarity_type_handled:
                list_handled_path_files.append((id,confidence))
            #else:
            elif polarity != PolarityType.OTHER: #or (polarity == PolarityType.OTHER and self._polarity_type_handled == None):
                #print id,polarity
                dict_handler_id_polarities[id] = [(polarity,confidence)]
            else:
                dict_handler_id_polarities[id] =[]
 
        
        if list_handled_path_files !=[]:
            for handler in self._list_handlers:
                list_aux_id_polarities = handler.classify(list_handled_path_files)
                for (id,polarity,confidence) in list_aux_id_polarities:
                    if dict_handler_id_polarities.has_key(id):
                        dict_handler_id_polarities[id].append((polarity,confidence))
                    else:
                        dict_handler_id_polarities[id] = [(polarity,confidence)]
        list_handled_id_polarities = [(id, dict_handler_id_polarities[id]) 
                                      for id in set(dict_handler_id_polarities)]
        return self._disambiguate_lists_id_polarities(list_handled_id_polarities)



        
    def to_key_value_format(self, list_id_category, dest_file):
        """
        It transforms the output provided by the classify method into a key-value format (QREL format).
        @para list_id_category: A list of tuples (fileId,category,confidence)
        @param dest_file: A string. The 
        """
        #dict_polarities = {id: (polarity,confidence) for id,polarity,confidence in list_id_category} 
        f = open(dest_file,"w")
        for id,category,_ in list_id_category:
            f.write(id+"\t"+category+"\n")
        f.close() 



#    def classify(self, list_path_files):
#        """
#        @precondition: path_files must refer ConLL 2006 files
#        @param list_path_files: A list to the path of the files to analyze
#        @return: A list of tuples (path_to_file, L{PolarityType}, confidence)
#        """
#
#        
#        list_linguistic_info = []
#        list_id_classifications = []
#        i = 0
#        dictionary_adapted_features = (self._analyzer.get_dictionary_adapted_features() 
#                                       if self.has_linguistic_analyzer() else None)
#        
#        ini = time.time()
#        
#        list_file_id_linguistic_info = self._analyzer.analyze_from_conll_list(list_path_files)
#
#        list_id_classifications.extend(self._classification_strategy.classify("a",list_path_files))
#
#        list_linguistic_info = []  
#        list_handled_path_files, list_aux_id_polarities = [],[]
#        dict_handler_id_polarities = {}
#        for (id,polarity,confidence) in list_id_classifications:
#            if polarity == self._polarity_type_handled:
#                list_handled_path_files.append((id,confidence))
#            #else:
#            elif polarity != PolarityType.OTHER: #or (polarity == PolarityType.OTHER and self._polarity_type_handled == None):
#                #print id,polarity
#                dict_handler_id_polarities[id] = [(polarity,confidence)]
#            else:
#                dict_handler_id_polarities[id] =[]
# 
#        
#        if list_handled_path_files !=[]:
#            for handler in self._list_handlers:
#                list_aux_id_polarities = handler.classify(list_handled_path_files)
#                for (id,polarity,confidence) in list_aux_id_polarities:
#                    if dict_handler_id_polarities.has_key(id):
#                        dict_handler_id_polarities[id].append((polarity,confidence))
#                    else:
#                        dict_handler_id_polarities[id] = [(polarity,confidence)]
#        list_handled_id_polarities = [(id, dict_handler_id_polarities[id]) 
#                                      for id in set(dict_handler_id_polarities)]
#        return self._disambiguate_lists_id_polarities(list_handled_id_polarities)




