'''
Created on 09/06/2014

@author: david.vilares
'''
import codecs
import socket
import base64
import time
import json


class ServerStrategy(object):
    '''
    ServerStrategy is intented to process an instance at a time. 
    '''

    def __init__(self, host,port,model_name,arff_header,max_bufsize=4092):
        '''
        Constructor
        @param host: A String
        @param port: An integer
        @param model_name: A String. It indicates the name of a existent model at the Server
        @param arff_header: A String. It indicates the header of the ARFF for the specified model
        '''
        self._host = host
        self._port = port
        self._model_name = model_name
        self._arff_header = arff_header
        self._max_bufsize = max_bufsize
        self._socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        self._socket.connect((self._host, self._port))
            
    def get_arff_header(self):
        return self._arff_header
    
    def get_instance_data(self, arff_file):
        
        arff_text = codecs.open(arff_file).read()
        arff_data = arff_text.split("@DATA\n")[1]
        return base64.b64encode(arff_data)
    
    def _call_server(self, data_string):
        self._socket.sendall('model:'+self._model_name+'\ntext:%s\n\n'%data_string) #sendall to send all data
        recv = ""
        # NOTE: every time we receive on a socket, there is no guarantee that it be a complete line, 
        # nor that it will be a single line. Therefore we'll store the complete response before processing
        while True:
            line = self._socket.recv(self._max_bufsize)#.replace('\n','').strip('[').strip(']').split(',')
            if line == '': break
            recv+=line
        print "RECV>",recv
        for line in recv.split('\n'):
            if line.startswith("classification:"):
                return json.loads(line.split("classification:")[1])#.strip('\n').strip('[').strip(']').replace(' ','')
    
    def classify(self, arff_file,dict_position_instanceid=None):
        """
        @param arff_file: 
        """
        #classifications = []
        return self._call_server(self.get_instance_data(arff_file))
        #print "server_lines:",lines
        #return lines
        #lines= self._get_model_classifications(arff_file)
        #line_id = 0
        #for line in lines:
        #    classifications.append((dict_position_instanceid[line_id],
        #                           line, 1))
        #    line_id += 1
        #return lines.split(',')

#s = ServerStrategy('zipi.dc.fi.udc.es',8081,"polarity_3c_es","/tmp/header.arff")
#s.classify("/tmp/header_with_data.arff",{0:2000,1:2001})
