'''
@author: David Vilares Calvo
'''

from miopia.classifier.ClassificationStrategy import ClassificationStrategy
from miopia.classifier.PolarityType import PolarityType

class QuaternaryStrategy(ClassificationStrategy):
    '''
    This strategy allows to classify texts such as Positive, Negative
    Neutral (the text merges positive and negative ideas) or None (without any sentiment)
    '''


    def __init__(self,threshold):
        '''
        Constructor
        @param threshold: A float. It establish a numerical threshold to distinguish between classes  
        '''
        super(QuaternaryStrategy,self).__init__(threshold)
    
    
    def _type(self, sentiment_info):
        """
        @param sentiment_info: A L{SentimentInfo} object
        @return: A L{PolarityType} value in {NEGATIVE, POSITIVE, NEUTRAL, NONE}
        """
        so = sentiment_info.get_so()
        subj = sentiment_info.get_subjectivity()
        
        if subj is False: return PolarityType.NONE
        else:
            if so > self._threshold: return PolarityType.POSITIVE
            if so < self._threshold: return PolarityType.NEGATIVE
            return PolarityType.NEUTRAL
    
