'''
Created on 25/06/2013

@author: David Vilares
'''

from miopia.classifier.ClassifierI import ClassifierI
from miopia.classifier.PolarityType import PolarityType

class MultiLabelClassifier(ClassifierI):
    '''
    classdocs
    '''


    def __init__(self,list_classifiers, backoff_category,backoff_confidence):
        '''
        Constructor
        '''
        self._list_classifiers = list_classifiers
        self._backoff_category = backoff_category
        self._backoff_confidence = backoff_confidence
    
    
        
      
    def classify(self,arff_file, results_file, dict_position_instanceid):
             
        dict_idfiles_categories = {}
        for classifier in self._list_classifiers:
            list_idfile_category = classifier.classify(arff_file, results_file, 
                                                       dict_position_instanceid)
            for id, category, confidence in list_idfile_category:               
                try:
                    if category != PolarityType.OTHER:
                        dict_idfiles_categories[id].append((category,confidence))
                    else:
                        dict_idfiles_categories[id].extend([])
                except KeyError:
                    if category == PolarityType.OTHER: 
                        dict_idfiles_categories[id] = []
                    else: 
                        dict_idfiles_categories[id] = [(category,confidence)]

        #dict to list
        list_id_categories = [(idfile,dict_idfiles_categories[idfile]) 
                              if len(dict_idfiles_categories[idfile]) != 0
                              else (idfile,[(self._backoff_category,self._backoff_confidence)]) 
                              for idfile in set(dict_idfiles_categories.keys())]
#        for id,categories in list_id_categories:
#            print id," ",categories
        return list_id_categories
        