'''
Created on 29/01/2013

@author: David Vilares Calvo
'''

from miopia.classifier.ClassificationStrategy import ClassificationStrategy
from miopia.classifier.PolarityType import PolarityType

class BinaryStrategy(ClassificationStrategy):
    '''
    This strategy allows to classify texts such as Positive or Negative
    '''


    def __init__(self,threshold):
        '''
        Constructor
        @param threshold: A float. It establish a numerical threshold to distinguish between classes  
        '''
        super(BinaryStrategy,self).__init__(threshold)
        
        
    def _type(self, sentiment_info):
        """
        @param sentiment_info: A L{SentimentInfo} object
        @return: A L{PolarityType} value in {NEGATIVE, POSITIVE}
        """
        if sentiment_info.get_so() > self._threshold: 
            return PolarityType.POSITIVE
        return PolarityType.NEGATIVE
    
    
 
        
        