'''
Created on 13/05/2014

@author: david.vilares
'''

from miopia.analyzer.counter.Counter import Counter

class SintacticCounter(Counter):
    '''
    An abstract class which provides the basic operations for the counters
    which rely on instances of L{SentimentDependencyGraph} to carry out their
    analysis.
    '''


    def __init__(self,ftc):
        '''
        @param ftc: An instance of L{FeatureTypeConfiguration}
        '''
        super(SintacticCounter,self).__init__(ftc)
        
    def _count(self, list_text_info):
        """
        @param list_text_info: A list of L{TextInfo} objects
        """
        dict_features = {}
        graphs = [(text_info.get_textid(),text_info.get_dependency_graphs()) 
                  for text_info in list_text_info]

        for textid, text_graphs in graphs:
            for text_graph,address in text_graphs:
                self._count_graph(textid,text_graph,address)
                dict_graph= self._count_graph(textid,text_graph, address) 
                
                for key in dict_graph.keys():
                    try:
                        dict_features[key]+= 1
                    except KeyError:
                        dict_features[key] = 1
                 
        return dict_features
        
    def _count_graph(self,textid,dg,address):
        raise NotImplementedError
