'''
Created on 25/02/2014

@author: David Vilares
'''

from miopia.analyzer.counter.SintacticCounter import SintacticCounter
from miopia.adapter.Feature import SentimentFeature
from miopia.util.exceptions.FeatureTypeConfigurationException import FeatureTypeConfigurationException


class SentimentCounter(SintacticCounter):
    '''
    This counter does not support additional semantic properties
    '''
    
    def __init__(self,ftc, list_desired_features,sentiment_analyzer):
        '''
        @param ftc: An instance of L{FeatureTypeConfiguration}
        @param list_desired_features: A set of L{SentimentFeature} values. It indicates the features
        that this counter will take from a L{SentimentDependencyGraph} once it has been analsed
        by the L{SentimentAnalyzer}
        @param sentiment_analyzer: A instance of L{SentimentAnalyzer}
        '''
        super(SentimentCounter,self).__init__(ftc)
        self._list_desired_features = list_desired_features
        self._sentiment_analyzer = sentiment_analyzer

    def _count_graph(self,textid,dg,address):
        
        """
        @param textid: A string. The text file identifier.
        @param dg: An instance of L{SentimentDependencyGraph}.
        @param address: An integer. The position of a node in the graph.
        """        

        if self._ftc.get_semantic_property() != None:
            raise FeatureTypeConfigurationException("SentimentCounter does not support semantic properties")

        sentiment_info = self._sentiment_analyzer.evaluate(dg,dg.get_by_address(address))
        dict_sentiment = {}
        
        node = dg.get_by_address(address)
        dict_sentiment[self._id_of_feature(textid, address, SentimentFeature.SUBJECTIVITY)] = sentiment_info.get_subjectivity()
        dict_sentiment[self._id_of_feature(textid, address, SentimentFeature.SEMANTIC_ORIENTATION)] = sentiment_info.get_so()
        dict_sentiment[self._id_of_feature(textid, address, SentimentFeature.POS_WORDS)] = sentiment_info.get_pos_words()
        dict_sentiment[self._id_of_feature(textid, address, SentimentFeature.NEG_WORDS)] = sentiment_info.get_neg_words()
        dict_sentiment[self._id_of_feature(textid, address, SentimentFeature.NUMBER_INTENSIFIERS)] = sentiment_info.get_number_intensifiers()
        dict_sentiment[self._id_of_feature(textid, address, SentimentFeature.LENGTH_TEXT)] = sentiment_info.get_length_text()
        dict_sentiment[self._id_of_feature(textid, address, SentimentFeature.NUMBER_WORDS)] = sentiment_info.get_number_words()

        return {feature_id: dict_sentiment[feature_id] for feature_id in dict_sentiment.keys() 
                if self.name_from_id(feature_id) in self._list_desired_features}    
    
   
    
