'''
Created on 02/04/2014

@author: David Vilares
'''
from miopia.analyzer.counter.LexiconCounter import LexiconCounter
from miopia.util.TokenInfo import TokenInfo

class ScorerCounter(LexiconCounter):
    '''
    classdocs
    '''

    ALL = "ALL"
    FIRST_MATCH = "FIRST_MATCH"

    def __init__(self, ftc, preprocessor, lexical_processor,
                 dict_lexicon, name_scoring, lowercase=True):
        
        '''
        Constructor
        '''
        super(ScorerCounter,self).__init__(ftc, preprocessor, lexical_processor,
                                           dict_lexicon, lowercase)
        self._scorings = set([self.ALL])
        self._name_scoring = name_scoring



    def _get_values(self,d,textid,initial_position,value):
        
        for scoring in self._scorings:
            scoring+="_"+self._name_scoring
            try:
                d[self._id_of_feature(textid, initial_position, scoring)]+=value
            except KeyError:
                d[self._id_of_feature(textid, initial_position, scoring)]=value
        return d




#a = ScorerCounter(None,None,None,{'mejor': [3,{'imposible': [5], 
#                                               'lo':[{'imposible':[-3]}]}]})
#
#list_token_info = [TokenInfo(token,None,None,None) for token in 'mejor es mejor imposible lo mejor lo imposible'.split()]
#
#abs = a._find_values(222,list_token_info[0], list_token_info[1:],1,1,{'mejor': [3,{'imposible': [5], 
#                                                                                   'lo':[{'imposible':[-3]}]}]})
#print "Abstracciones", abs


#    