'''
Created on 13/05/2014

@author: david.vilares
'''

from miopia.analyzer.counter.Counter import Counter
from nltk.util import ngrams

class RawCounter(Counter):
    '''
    An abstract class which provides methods for the Counters which don't need
    to rely on the L{SentimentDependencyGraph}
    '''


    def __init__(self,ftc, lowercase=True):
        '''
        @param ftc: An instance of L{FeatureTypeConfiguration}
        @param lowercase: A boolean. True to ignore capitalised characters.
        '''
        super(RawCounter,self).__init__(ftc)
        self._lowercase = lowercase
        
    def raw_processing(self, list_text_info):
        raw_texts = [(text_info.get_textid(),
                      self._preprocessor.preprocess(text_info.get_text())) 
                     for text_info in list_text_info]
        sentences = [(textid,self._lexical_processor.extract_sentences(ptext)) 
                     for (textid,ptext) in raw_texts ]
        tokens = [(textid, self._lexical_processor.extract_tokens(sentences)[0]) 
                  for textid, sentences in sentences]
        
        tags = [(textid, self._lexical_processor.extract_tags(tokens)) 
                for textid, tokens in tokens]
        return tags

    def _filter(self,string):
        return string.lower() if self._lowercase else string

    def _count(self, list_text_info):
        raise NotImplementedError
