'''
Created on 25/02/2014

@author: david.vilares
'''

from miopia.analyzer.counter.SintacticCounter import SintacticCounter
from miopia.util.TextInfo import TextInfo
class DependencyTypeCounter(SintacticCounter):
    '''
    @warning: Not working properly
    '''


    def __init__(self, ftc,stop_dependencies=set([]),
                 dict_subgraph_classifiers_info=None):
        '''
        Constructor
        '''
        super(DependencyTypeCounter,self).__init__(ftc)
        self._stop_dependencies = stop_dependencies
        self._dict_subgraph_classifiers_info = dict_subgraph_classifiers_info


    def _count(self, list_text_info):
        dict_features = {}
        list_subgraphs_text_info = []
        
#        graphs = [(text_info.get_textid(),text_info.get_dependency_graphs()) 
#                  for text_info in list_text_info]
        for text_info in list_text_info:
            textid = text_info.get_textid()
            text_graphs = text_info.get_dependency_graphs()
            list_subgraphs_text_info = []
            for graph,address in text_graphs:
                dict_features_graph = self._count_graph(textid, graph, address)
                
                for _,address,name in dict_features_graph:   
                    subrange = self._get_subtext_range(graph, address)             
                    subrange.sort(key= lambda t: t[0])
                    subtext = ' '.join([word for address,word in subrange])
                    new_text_info = TextInfo(textid+"_"+str(address),subtext,[(graph,address)],
                                             text_info.get_metadata(),'?')
                    list_subgraphs_text_info.append(new_text_info)
                
            subgraph_adapter = self._dict_subgraph_classifiers_info['DEFAULT'].get_adapter()
            subgraph_classifier = self._dict_subgraph_classifiers_info['DEFAULT'].get_classifier()
            subgraph_arff_header = self._dict_subgraph_classifiers_info['DEFAULT'].get_arff_header()
            subgraph_dest_test_arff = self._dict_subgraph_classifiers_info['DEFAULT'].get_arff_path()
            dict_position_instanceid = subgraph_adapter.to_arff(list_subgraphs_text_info,
                                                                subgraph_dest_test_arff, 
                                                                subgraph_arff_header, True)
            subgraph_results_file =  self._dict_subgraph_classifiers_info['DEFAULT'].get_results_path()
            
            list_id_category = subgraph_classifier.classify(subgraph_dest_test_arff, subgraph_results_file, 
                                                                dict_position_instanceid)
            print textid, text_info.get_category(),list_id_category
            print [t.get_text() for t in list_subgraphs_text_info]
#        for textid, text_graphs in graphs:
#            for text_graph in text_graphs:
#                self._count_graph(textid,text_graph,0)
#                dict_graph= self._count_graph(textid,text_graph, 0) 
#                
##                subgraph_classifier, adapter = self._dict_subgraph_classifiers['XX']
#                
#                
#                for key in dict_graph.keys():
#                    try:
#                        dict_features[key]+= 1
#                    except KeyError:
#                        dict_features[key] = 1

    def _get_subtext_range(self,dependency_graph,address):
        node = dependency_graph.get_by_address(address)
        form = dependency_graph.get_word(node)
        if dependency_graph.is_leaf(node):
            return [(address,form)]
        else:
            raw_nodes = [(address, form)]
            children = dependency_graph.get_deps(node)
            for child in children:
                raw_nodes.extend(self._get_subtext_range(dependency_graph,child))
            return raw_nodes

#    def _get_text_from_graph(self, dependency_graph, address):
#        node = dependency_graph.get_by_address(address)
#        if dependency_graph.is_leaf(node):
#            return [node]
#        else:
#            raw_nodes = [node]
#            children = dependency_graph.get_deps(node)
#            for child in children:
#                raw_nodes.extend(self._get_text_from_graph(dependency_graph,child))
#            return raw_nodes



    def _count_graph(self,textid,dg,address):
        
        #print textid, dg, address
        node = dg.get_by_address(address)           
        if dg.is_leaf(node):
            return {self._id_of_feature(textid, address, dg.get_rel(node)):1}
        else:
            #print self._id_of_feature(textid, dg.get_rel(node))
            dict_features = {self._id_of_feature(textid, address,dg.get_rel(node)):1}
            children = dg.get_deps(node)
            for child in children:
                dict_child = self._count_graph(textid,dg, child) 
                dict_features = dict((n, dict_features.get(n,0)+dict_child.get(n,0)) 
                                     for n in set(dict_features)| set(dict_child))
            return (dict_features)      
         
         




