'''
Created on 25/02/2014

@author: david.vilares
'''

from miopia.analyzer.counter.SintacticCounter import SintacticCounter
from miopia.adapter.Feature import FeatureLevelBackOff
from miopia.adapter.Feature import FeatureTypeConfiguration
from miopia.util.TokenInfo import TokenInfo
import itertools


class DependencyTripletsCounter(SintacticCounter):
    '''
    This Counter is responsible of counting dependency triplets present in a 
    L{SentimentDependencyGraph}
    '''


    def __init__(self, ftc, back_off,stop_words=set([])):
        '''
        @param ftc: An instance of L{FeatureTypeConfiguration}
        @param back_off: An instance of L{BackOff}
        @param stop_words: A set of words that shoudn't be taken into account
        '''
        super(DependencyTripletsCounter,self).__init__(ftc)
        self._stop_words = stop_words
        self._back_off = back_off
    

    def _count_graph(self,textid,dg,address):
        """
        @param textid: A string. The identifier of the text.
        @param dg: An instance of L{SentimentDependencyGraph}
        @param address: An integer. The node identifier in the graph. 
        """
        node = dg.get_by_address(address)   
        if dg.is_leaf(node):
            return {}
        else:     
            dict_dep = {}
            children = dg.get_deps(node)
            for child in children:
                child_node = dg.get_by_address(child)

                tih = TokenInfo(dg.get_word(node),None, dg.get_ctag(node),dg.get_tag(node))
                tid = TokenInfo(dg.get_word(child_node),None, 
                                dg.get_ctag(child_node),dg.get_tag(child_node))
                head_value = self._back_off.back_off(tih, self._ftc.get_back_off_head())
                dependent_value = self._back_off.back_off(tid, self._ftc.get_back_off_dependent())
                

                if type(head_value) != type([]):
                    head_value = [head_value]             
                if type(dependent_value) != type([]):
                    dependent_value = [dependent_value]
                
                list_pairs_head_dependent = itertools.product(head_value, 
                                                              dependent_value)
                for pair in list_pairs_head_dependent:
                    if pair[0] in self._stop_words or pair[1] in self._stop_words:
                        continue
                    
                    if self._ftc.get_add_dependency_type() is True:
                        dependency_triplet = self._id_of_feature(textid,address,pair[0]+"-"+dg.get_rel(child_node)+"-"+pair[1])
                    else:
                        dependency_triplet = self._id_of_feature(textid,address,pair[0]+"-"+pair[1])
                        
                    if dict_dep.has_key(dependency_triplet):
                        dict_dep[dependency_triplet] += 1.
                    else:
                        dict_dep[dependency_triplet] = 1. 
                    
                dict_child = self._count_graph(textid,dg,child) 
                dict_dep = dict((n, dict_dep.get(n,0)+dict_child.get(n,0)) for n in set(dict_dep)| set(dict_child))  
            return (dict_dep) 
