'''
Created on 13/05/2014

@author: David Vilares
'''

class Counter(object):
    '''
    Abstract class which provides the basic operations for the rest of the Counters.
    '''

    BINARY = "BINARY"
    TOTAL ="TOTAL"

    def __init__(self, ftc, weighting_factor = BINARY):
        '''
        @param ftc: An instance of L{FeatureTypeConfiguration}
        '''
        self._ftc = ftc 
        #self._weighting_factor = weighting_factor


    def get_feature_type_configuration(self):
        return self._ftc

    def _id_of_feature(self, text_id, position ,name):
        """
        Append to the name of the feature a value of a category of L{FeatureSemanticProperty}
        @param str_name_feature: The basic name of the feature
        @param value_semantic_property: A value of a category specified at L{FeatureSemanticProperty}
        """
        #return name
        return (text_id,position,name)



    def name_from_id(self,feature_id):
        """
        @param feature_id: A tuple (textid, position,name) which identifies a feature in a file and in a graph.
        @return The name of the feature.
        """
        #TODO: This is duplicated in L{Adapter}
        return feature_id[2]


    def file_id(self, feature_id):
        """
        @param feature_id: A tuple (textid, position,name) which identifies a feature in a file and in a graph.
        @return The file identifier where the current feature was found.
        """
        return feature_id[0]


    def count(self,list_text_info):
        """
        @param list_text_info: A list of L{TextInfo} objects
        @return The collection of of features that were found in list_text_info
        """       
        return self._count(list_text_info)
        
