'''
Created on 14/03/2014

@author: David Vilares
'''


from miopia.analyzer.counter.LexiconCounter import LexiconCounter
from miopia.util.TokenInfo import TokenInfo
from nltk.util import ngrams


class AbstractedLexiconsCounter(LexiconCounter):

    '''
    This counter to manage counters which use external knowledge to obtain
    features for the supervised classifier.
    '''

    def __init__(self, ftc, preprocessor, lexical_processor,
                 dict_lexicon,lowercase=True):
        
        '''
        @param ftc: An instance of L{FeatureTypeConfiguration}
        @param preprocessor: An instance of L{PreprocessorI}
        @param lexical_processor: An instance of L{LexicalProcessor}
        @param dict_lexicon: A nested dictionary {key:[Category,{key:[ ... ]}]}
        @param lowercase: A boolean. True to ignore capitalised characters.
        '''
        super(AbstractedLexiconsCounter,self).__init__(ftc,preprocessor,
                                                       lexical_processor,
                                                       dict_lexicon, lowercase)
        

    def _sublist_tokens(self,list_tokens):
        for t in list_tokens:
            print t,
    

    def _get_values(self,d,textid,initial_position,value):
        try:
            d[self._id_of_feature(textid, initial_position, value)]+=1
        except KeyError:
            d[self._id_of_feature(textid, initial_position, value)]=1
        return d





