'''
@author: David Vilares
'''

class SentimentInfo(object):
        
    
    '''
    SentimentInfo stores relevant information about a branch of a L{SentimentDependencyGraph}
    '''

        
    def __init__(self,intensifier,so, subjectivity,pos_words,neg_words, 
                 number_intensifiers, length_text, number_words):
        '''
        Constructor
        @param intensifier: A float. It indicates the degree of intensification
        @param so: A float. It indicates the Semantic Orientation
        @param subjectivity: A boolean. True if node has subjectivity, False otherwise
        @param pos_words: An integer. The number of positive words.
        @param neg_words: An integer. The number of negative words.
        @param number_intensifiers: An integer. The number of intensifiers.
        @param length_text: An integer. The length of the text (in that node)
        @param number_words: An integer. The number of words. 
        '''
        self._intensifier = intensifier 
        self._so = so
        self._subjectivity = subjectivity
        self._pos_words = pos_words
        self._neg_words = neg_words
        self._number_intensifiers = number_intensifiers
        self._length_text = length_text
        self._number_words =  number_words

        
    
    def get_int(self):
        return self._intensifier

    def get_so(self):
        return self._so
    
    def get_subjectivity(self):
        return self._subjectivity
    
    def set_pos_words(self,pos_words):
        self._pos_words = pos_words
    
    def get_pos_words(self):
        return self._pos_words
    
    def set_neg_words(self, neg_words):
        self._neg_words = neg_words
    
    def get_neg_words(self):
        return self._neg_words
    
    def get_number_intensifiers(self):
        return self._number_intensifiers
    
    def get_length_text(self):
        return self._length_text
    
    def get_number_words(self):
        return self._number_words
        
    
        