'''
@author: David Vilares
'''

class NegationInfo(object):
    '''
    Auxiliary structure for analyzing negation 
    '''


    def __init__(self,neg_branches,other_branches,delimiter):
        """
        Constructor
        @param neg_branches: Branches affected by a negation term
        @param other_branches: Branches not affected by a negation term
        @param delimiter:  A syntactic rule delimiter. An element of L{Negationrules}
        """
        self.__neg_branches = neg_branches
        self.__other_branches = other_branches
        self.__delimiter = delimiter
    
    def get_neg_branches(self):
        return self.__neg_branches
    
    def get_other_branches(self):
        return self.__other_branches
    
    def get_delimiter(self):
        return self.__delimiter