'''
Created on 16/05/2014

@author: David Vilares
'''

from miopia.adapter.Feature import FeatureLevelBackOff


class BackOff(object):
    '''
    This class manages the generalisations (a.k.a as back-off) which make possible to represent tokens
    as more abstract concepts. 
    '''

    NGRAM_BACK_OFF_DELIMITER = "-"
    EMPTY_TOKEN = "EMPTY_TOKEN"
    
    
    def __init__(self, dictionary):
        '''
        @param dictionary: An instance of a L{Dictionary}
        '''
        super(BackOff,self).__init__()
        self._dictionary = dictionary
     
     
    def back_off(self, token_info, type_back_off):
        """
        @param token_info: A instance of a L{TokenInfo}
        @param type_back_off: A valid value for L{FeatureLevelBackOff}
        """

        if type_back_off == FeatureLevelBackOff.TYPE_BACK_OFF_COARSE_TAG: 
            return token_info.get_ctag()
        if type_back_off == FeatureLevelBackOff.TYPE_BACK_OFF_FINE_TAG:
            return token_info.get_ftag()
        if type_back_off == FeatureLevelBackOff.TYPE_BACK_OFF_LEMMA:
            return self._dictionary.get_lemma(token_info.get_ctag(),
                                              token_info.get_form()).lower()
        if type_back_off == FeatureLevelBackOff.TYPE_BACK_OFF_POLARITY_WORDS:
            raise NotImplementedError
        if type_back_off == FeatureLevelBackOff.TYPE_BACK_OFF_SEMANTIC_ORIENTATION: 
            raise NotImplementedError
        if type_back_off == FeatureLevelBackOff.TYPE_BACK_OFF_WORD: 
            return token_info.get_form()
        if type_back_off == FeatureLevelBackOff.TYPE_BACK_OFF_PSYCHOMETRIC: 
            return self._dictionary.get_psychometric_categories(token_info.get_form().lower())        
        if type_back_off == FeatureLevelBackOff.TYPE_BACK_OFF_EMPTY:
            return self.EMPTY_TOKEN