'''
Created on 14/02/2013

@author: David Vilares Calvo
'''

class AnalyzerConfiguration(object):
    '''
    AnalyzerConfiguration sets the configuration of a L{SentimentAnalyzer}
    '''


    def __init__(self,final_sentences_weight=1.75, caps_int=0.1, 
                 replication_int=0.25, restrictive_adv_weight=0.75,
                 restrictive_main_weight=1.4, without_shift = 3.55,
                 neg_shift=4):
        '''
        Constructor
        @param final_sentence_weight: A float. The weighting factor for final sentences.
        @param caps_int: A float. The weighting factor for capitalized words.
        @param replication_int: A float. The weighting factor for words with replicated characters.
        @param restrictive_adv_weight: A float. The weighting factor for adversative subordinate clause.
        @param restrictive_main_weight: A float. The weighting factor for the main sentence of a subordinate clause.
        @param without_shift: A float. The shift value to negate 'sin' ('without') phrases.
        @param neg_shift: A float. The shift value value to negate 'no' ('not') and 'nunca' ('never') phrases.
        '''
        self._final_sentences_weight = final_sentences_weight
        self._caps_int = caps_int
        self._replication_int=replication_int
        self._restrictive_adv_weight=restrictive_adv_weight
        self._restrictive_main_weight=restrictive_main_weight
        self._without_weight=without_shift
        self._neg_weight=neg_shift
        
        
        
    def get_final_sentences_weight(self):
        return self._final_sentences_weight
    
    def get_caps_int(self):
        return self._caps_int
    
    def get_replication_int(self):
        return self._replication_int
    
    def get_restrictive_adv_weight(self):
        return self._restrictive_adv_weight
    
    def get_restrictive_main_weight(self):
        return self._restrictive_main_weight
    
    def get_without_shift(self):
        return self._without_weight
    
    def get_neg_shift(self):
        return self._neg_weight
    
        