'''
Created on 20/05/2014

@author: david.vilares
'''

from miopia.adapter.RawAdapter import RawAdapter
from miopia.analyzer.counter.UnGrammaticalCounter import UnGrammaticalCounter
from miopia.adapter.Feature import FeatureType

class UnGrammaticalAdapter(RawAdapter):
    '''
    A WEKA adapter for L{UnGrammaticalCounter}
    '''


    def __init__(self,path_weka, ungrammatical_counter, weight_factor):
        """
        @param path_weka: The path to the WEKA.jar
        @param abstracted_lexicons_counter: An instance of L{UnGrammaticalCounter}
        @param weight_factor: A value {BINARY_WEIGHTING_FACTOR, TOTAL_WEIGHTING_FACTOR}
        """

        
        if not isinstance(ungrammatical_counter,UnGrammaticalCounter):
            raise ValueError
        
        super(UnGrammaticalAdapter,self).__init__(path_weka, ungrammatical_counter,
                                                  weight_factor)
        
    
    def _get_feature_type(self):
        """
        The type of the feature
        """
        return FeatureType.UNGRAMMATICAL
        