'''
Created on 14/05/2014

@author: david.vilares
'''

from miopia.adapter.Adapter import Adapter
from miopia.analyzer.counter.SintacticCounter import SintacticCounter


class SintacticAdapter(Adapter):
    '''
    An abstract class for  WEKA adapters for L{SintacticCounter}
    '''
    
    
    def __init__(self, path_weka, sintactic_counter, weight_factor):
        '''
        @param path_weka: The path to the WEKA.jar
        @param abstracted_lexicons_counter: An instance of L{AbstractedLexiconsCounter}
        @param weight_factor: A value {BINARY_WEIGHTING_FACTOR, TOTAL_WEIGHTING_FACTOR}
        '''
        if not isinstance(sintactic_counter,SintacticCounter):
            raise ValueError
        
        super(SintacticAdapter,self).__init__(path_weka, sintactic_counter,weight_factor)
        
    def _get_feature_type(self):
        """
        The type of the feature
        """
        raise NotImplementedError
    
    