'''
Created on 09/10/2013

@author: David Vilares
'''


from miopia.adapter.SintacticAdapter import SintacticAdapter
from miopia.adapter.Feature import FeatureType
from miopia.util.exceptions.FeatureTypeConfigurationException import FeatureTypeConfigurationException
from miopia.analyzer.counter.SentimentCounter import SentimentCounter

class SentimentAdapter(SintacticAdapter):
    '''
    SentimentAdapter allows to obtain sentiment features from L{src.miope.analyzer.SentimentAnalyzer} 
    to then train a L{src.miope.classifier.ClassifierI}
    '''


    def __init__(self,path_weka, sentiment_counter):
        '''
        @param path_weka: The path to the WEKA.jar
        @param abstracted_lexicons_counter: An instance of L{SentimentCounter}
        '''

        if not isinstance(sentiment_counter, SentimentCounter):
            raise ValueError

        super(SentimentAdapter,self).__init__(path_weka,sentiment_counter,
                                              self.TOTAL_WEIGHTING_FACTOR)
        print "Weight_factor",self._weighting_factor, self.TOTAL_WEIGHTING_FACTOR
    
    def _get_feature_type(self):
        """
        @return: A string with the feature type provided by the SentimentAdapter 
        """
        return FeatureType.SENTIMENT_FEATURE
    
