'''
Created on 09/04/2014

@author: David Vilares
'''

from miopia.adapter.RawAdapter import RawAdapter
from miopia.adapter.Feature import FeatureType
from miopia.analyzer.counter.ScorerCounter import ScorerCounter

class ScorerAdapter(RawAdapter):
    '''
    A WEKA adapter for L{ScorerCounter}
    '''

    def __init__(self,path_weka, scorer_counter):
        '''
        @param path_weka: The path to the WEKA.jar
        @param abstracted_lexicons_counter: An instance of L{ScorerCounter}
        '''

        if not isinstance(scorer_counter, ScorerCounter):
            raise ValueError

        super(ScorerAdapter,self).__init__(path_weka,scorer_counter, 
                                           self.TOTAL_WEIGHTING_FACTOR)

    
    def _get_feature_type(self):
        """
        The type of the feature
        """
        return FeatureType.SCORED
