'''
Created on 25/09/2013

@author: David Vilares
'''

from miopia.adapter.Feature import FeatureType
from miopia.adapter.RawAdapter import RawAdapter
from miopia.analyzer.counter.NGramCounter import NGramCounter

class NGramAdapter(RawAdapter):
    '''
    A WEKA adapter for L{NGramCounter}
    '''


    def __init__(self,path_weka, ngram_counter, weight_factor):
        """
        @param path_weka: The path to the WEKA.jar
        @param abstracted_lexicons_counter: An instance of L{NGramCounter}
        @param weight_factor: A value {BINARY_WEIGHTING_FACTOR, TOTAL_WEIGHTING_FACTOR}
        """

        
        if not isinstance(ngram_counter,NGramCounter):
            raise ValueError
        
        super(NGramAdapter,self).__init__(path_weka,ngram_counter,weight_factor)
        
    
    def _get_feature_type(self):
        """
        The type of the feature
        """
        return FeatureType.GRAM
    

