'''
Created on 10/04/2013

@author: David Vilares Calvo
'''

from miopia.adapter.Feature import FeatureType
from miopia.adapter.SintacticAdapter import SintacticAdapter
from miopia.util.exceptions.FeatureTypeConfigurationException import FeatureTypeConfigurationException
from miopia.analyzer.counter.DependencyTypeCounter import DependencyTypeCounter


class DependencyTypeAdapter(SintacticAdapter):
    '''
    A WEKA adapter for L{DependencyCounter}
    '''


    def __init__(self,path_weka, dependency_type_counter, weight_factor):
        """
        @param path_weka: The path to the WEKA.jar
        @param abstracted_lexicons_counter: An instance of L{DependencyTypeCounter}
        @param weight_factor: A value {BINARY_WEIGHTING_FACTOR, TOTAL_WEIGHTING_FACTOR}
        """

        if not isinstance(dependency_type_counter, DependencyTypeCounter):
            raise ValueError

        super(DependencyTypeAdapter,self).__init__(path_weka,dependency_type_counter,
                                                   weight_factor)

        
        
    def _get_feature_type(self):
        """
        The type of the feature
        """
        return FeatureType.DEPENDENCY
    

            