'''
Created on 11/04/2013

@author: David Vilares Calvo
'''

from miopia.adapter.Feature import FeatureType
from miopia.adapter.SintacticAdapter import SintacticAdapter
from miopia.analyzer.counter.DependencyTripletsCounter import DependencyTripletsCounter
from miopia.util.exceptions.FeatureTypeConfigurationException import FeatureTypeConfigurationException

class DependencyTripletsAdapter(SintacticAdapter):
    '''
    A WEKA adapter for L{DependencyTripletsCounter}
    '''

    def __init__(self,path_weka, dependency_triplets_counter,weight_factor):
        '''
        @param path_weka: The path to the WEKA.jar
        @param abstracted_lexicons_counter: An instance of L{DependencyTripletsCounter}
        @param weight_factor: A value {BINARY_WEIGHTING_FACTOR, TOTAL_WEIGHTING_FACTOR}
        '''

        if not isinstance(dependency_triplets_counter, DependencyTripletsCounter):
            raise ValueError

        super(DependencyTripletsAdapter,self).__init__(path_weka,dependency_triplets_counter,
                                                       weight_factor)
        
        

    def _get_feature_type(self):
        """
        The type of the feature
        """
        return FeatureType.DEPENDENCY_TRIPLET
    

        
