'''
Created on 28/05/2013

@author: David Vilares Calvo
'''

from miopia.parser.Parser import Parser
from miopia.adapter.Adapter import Adapter
from collections import defaultdict, OrderedDict
import os


class CompositeAdapter(Adapter):
    '''
    CompositeAdapter allows to combine different L{Adapter}'s to obtain a global ranking
    off all features
    '''
    FEATURE_TYPE = "COMPOSITE_FEATURE_TYPE"

    def __init__(self,path_weka,counter):
        '''
        @param path_weka: The path to the WEKA.jar
        @param counter: An instance of L{CompositeAuxiliaryCounter}
        '''
        self._list_adapters = []
        self._list_external_resources = []
        super(CompositeAdapter,self).__init__(path_weka,counter,None)
        self._dict_str_ftc_adapter_weight = {}
        
    def add(self,adapter):
        """
        Add an L{Adapter} to the composite adapter
        """
        self._list_adapters.append(adapter)
        self._dict_str_ftc_adapter_weight[str(adapter._get_feature_type())] = adapter.get_weighting_factor()
        
    def remove(self,adapter):
        """
        Remove and L{Adapter} from the composite adapter 
        """
        self._list_adapters.remove(adapter)
        self._dict_str_ftc_adapter_weight.pop(str(adapter._get_feature_type()))
        
    def get_children(self):
        """
        Obtain the children of a L{CompositeAdapter}
        """
        return self._list_adapters
    
    def _get_feature_type(self):
        return self.FEATURE_TYPE
    
    
    def _analyze_graph(self,dgs):
        dict_features = {}
        for adapter in self._list_adapters:
            dict_features.update(adapter._analyze_graph(dgs))
        return dict_features


    def count_features(self,list_text_info):
        """
        @return A dictionary with the number of features considered by the adapter in an instance
        of a L{nltk.parse.dependencygraph.DependencyGraph} 
        """
        dict_features = {}
        for adapter in self._list_adapters:
            dict_features.update(adapter.count_features(list_text_info))
        return dict_features
    
    def get_weighting_value(self,str_ftc,value):
        
        weighting_factor = self._dict_str_ftc_adapter_weight[str_ftc]
        if weighting_factor == self.BINARY_WEIGHTING_FACTOR:
            return 1
        if weighting_factor == self.TOTAL_WEIGHTING_FACTOR:
            return value




    