'''
Created on 14/03/2014

@author: david.vilares
'''


from miopia.adapter.RawAdapter import RawAdapter
from miopia.adapter.Feature import FeatureType
from miopia.analyzer.counter.AbstractedLexiconsCounter import AbstractedLexiconsCounter

class AbstractedLexiconsAdapter(RawAdapter):
    '''
    A WEKA adapter for L{AbstractedLexiconsCounter}
    '''

    def __init__(self,path_weka, abstracted_lexicons_counter, weight_factor):
        '''
        @param path_weka: The path to the WEKA.jar
        @param abstracted_lexicons_counter: An instance of L{AbstractedLexiconsCounter}
        @param weight_factor: A value {BINARY_WEIGHTING_FACTOR, TOTAL_WEIGHTING_FACTOR}
        '''
        
        if not isinstance(abstracted_lexicons_counter, AbstractedLexiconsCounter):
            raise ValueError
        super(AbstractedLexiconsAdapter,self).__init__(path_weka,abstracted_lexicons_counter,weight_factor)

    
    def _get_feature_type(self):
        """
        @return the type of the feature
        """
        return FeatureType.ABSTRACTED_LEXICON
    
